package com.elitesland.tw.tw5.api.common.funConfig.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
@Getter
@Setter
public class BusinessTableQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 名称 精确 */
    @ApiModelProperty("名称")
    private String name;
    /** 数据库表名 精确 */
    @ApiModelProperty("数据库表名")
    private String tableName;

    @ApiModelProperty("数据库表名equals")
    private String tableNameEquals;
    /** 业务关系 MIAN 主表 DETAIL 明细表 精确 */
    @ApiModelProperty("业务关系 MIAN 主表 DETAIL 明细表")
    private String type;
    /** 功能主键 prd_system_function.id 精确 */
    @ApiModelProperty("功能主键 prd_system_function.id")
    private Long functionId;
    /** 是否启用 精确 */
    @ApiModelProperty("是否启用")
    private Boolean enabled;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
