package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingContinuousPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingContinuousQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
public interface AccReimSettingContinuousService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingContinuousVO}>
     */
    PagingVO<AccReimSettingContinuousVO> queryPaging(AccReimSettingContinuousQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingContinuousVO}>
     */
    List<AccReimSettingContinuousVO> queryListDynamic(AccReimSettingContinuousQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingContinuousVO}
     */
    AccReimSettingContinuousVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingContinuousVO}
     */
    AccReimSettingContinuousVO insert(AccReimSettingContinuousPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingContinuousVO}
     */
    AccReimSettingContinuousVO update(AccReimSettingContinuousPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingContinuousPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 规则检查
     * @param key
     * @param invInvoiceVOS
     * @return
     */
    AccReimSettingContinuousVO ruleCheck(Long key, List<InvInvoiceVO> invInvoiceVOS, Long reimUserId);
}
