package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import io.swagger.annotations.ApiModel;
import com.elitescloud.boot.common.param.BaseViewModel;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细
 */

@Data
@ApiModel(description = "绩效考核结果明细")
public class PrdPerformanceExamResDtlVO extends BaseViewModel {


    /**
     * 绩效考核结果id
     */
    @ApiModelProperty("绩效考核结果id")
    private Long resultId;

    /**
     * 考核点id
     */
    @ApiModelProperty("考核点id")
    private Long pointId;

    /**
     * 考核点名称
     */
    @ApiModelProperty("考核点名称")
    private String pointName;

    /**
     * 评分类型
     */
    @ApiModelProperty("评分类型")
    private String scoreType;

    /**
     * 考核点权重
     */
    @ApiModelProperty("考核点权重")
    private BigDecimal weightRatio;

    /**
     * 系统考核统计
     */
    @ApiModelProperty("系统考核统计")
    private String sysExam;

    /**
     * 评分结果
     */
    @ApiModelProperty("评分结果")
    private BigDecimal scoreRes;

    /**
     * 自评说明
     */
    @ApiModelProperty("自评说明")
    private String selfEval;

    /**
     * 考评人
     */
    @ApiModelProperty("考评人")
    private String evalUser;

    /**
     * 考评人id
     */
    @ApiModelProperty("考评人id")
    private Long evalUserId;

    /**
     * 评语
     */
    @ApiModelProperty("评语")
    private String evalDesc;

    /**
     * 评分标准
     */
    @ApiModelProperty("评分标准")
    private String standardDesc;
}

