package com.elitesland.tw.tw5.api.prd.partner.business.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务合作伙伴-工商股东
 *
 * @author wangly
 * @date 2023-05-18
 */
@Getter
@Setter
public class BusinessOperationPartnerQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 地址簿id 精确 */
    @ApiModelProperty("地址簿id")
    private Long bookId;
    /** 总实缴 精确 */
    @ApiModelProperty("总实缴")
    private String totalRealCapi;
    /** 出资时间 精确 */
    @ApiModelProperty("出资时间")
    private String date;
    /** 历史股东 精确 */
    @ApiModelProperty("历史股东")
    private String isHstory;
    /** 股东类型 精确 */
    @ApiModelProperty("股东类型")
    private String stockType;
    /** 股东姓名 精确 */
    @ApiModelProperty("股东姓名")
    private String name;
    /** 人员id（股东为自然人显示pid） 精确 */
    @ApiModelProperty("人员id（股东为自然人显示pid）")
    private String pid;
    /** 认缴出资列表 精确 */
    @ApiModelProperty("认缴出资列表")
    private String shouldcapiitems;
    /** 总认缴 精确 */
    @ApiModelProperty("总认缴")
    private String totalShouldCapi;
    /** 股比 精确 */
    @ApiModelProperty("股比")
    private String stockPercent;
    /** 企业id（股东为企业显示eid） 精确 */
    @ApiModelProperty("企业id（股东为企业显示eid）")
    private String eid;
    /** 类型 精确 */
    @ApiModelProperty("类型")
    private String identifyType;
    /** 认缴出资额 精确 */
    @ApiModelProperty("认缴出资额")
    private String capi;
    /** 股东ID 精确 */
    @ApiModelProperty("股东ID")
    private String identifyNo;
    /** 实缴出资列表 精确 */
    @ApiModelProperty("实缴出资列表")
    private String realCapiItems;
    /** 出资方式 精确 */
    @ApiModelProperty("出资方式")
    private String type;
    /** 业务伙伴主键 business_partner.id 精确 */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 业务伙伴名称 精确 */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
}
