package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitesland.tw.tw5.api.prd.partner.business.payload.AccreditProjectRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.AccreditProjectRefVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户授权项目关联管理
 *
 * @author wangly
 * @date 2024-12-05
 */
public interface AccreditProjectRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccreditProjectRefVO}>
     */
    PagingVO<AccreditProjectRefVO> queryPaging(AccreditProjectRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccreditProjectRefVO}>
     */
    List<AccreditProjectRefVO> queryListDynamic(AccreditProjectRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccreditProjectRefVO}
     */
    AccreditProjectRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccreditProjectRefVO}
     */
    AccreditProjectRefVO insert(AccreditProjectRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccreditProjectRefVO}
     */
    AccreditProjectRefVO update(AccreditProjectRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccreditProjectRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
