package com.elitesland.tw.tw5.api.prd.partner.strategy.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;


/**
  * 分级策略
  *
  * @author wangly
  * @date 2023-06-16
  */
@Getter
@Setter
public class BusinessStrategyVO extends BaseViewModel implements Serializable {
    /** 策略编号 */
    @ApiModelProperty("策略编号")
    private String strategyNo;

    /** 分级策略名称 */
    @ApiModelProperty("分级策略名称")
    private String strategyName;

    /** 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @ApiModelProperty("分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String strategyIdentity;

    /** 分级策略适用身份描述 udc[CRM:BUSINESS_PARTNER:IDENTITY] */
    @ApiModelProperty("分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    @UdcName(udcName = "CRM:BUSINESS_PARTNER:IDENTITY",codePropName = "strategyIdentity")
    private String strategyIdentityDesc;

    /** 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS] */
    @ApiModelProperty("策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]")
    private String strategyStatus;

    /** 策略状态描述 udc[CRM:BUSINESS_STRATEGY:STATUS] */
    @ApiModelProperty("策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY:STATUS",codePropName = "strategyStatus")
    private String strategyStatusDesc;

    /** 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY] */
    @ApiModelProperty("策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]")
    private String strategyPriority;

    /** 策略优先级描述 udc[CRM:BUSINESS_STRATEGY:PRIORITY] */
    @ApiModelProperty("策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY:PRIORITY",codePropName = "strategyPriority")
    private String strategyPriorityDesc;

    /** 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE] */
    @ApiModelProperty("策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]")
    private String strategyRange;

    /** 策略范围描述 udc[CRM:BUSINESS_STRATEGY:RANGE] */
    @ApiModelProperty("策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]")
    @UdcName(udcName = "CRM:BUSINESS_STRATEGY:RANGE",codePropName = "strategyRange")
    private String strategyRangeDesc;

    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;

    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;

    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;

    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;

    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;

    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /** 策略范围明细 */
    @ApiModelProperty("策略范围明细")
    private String strategyRangeDetail;

    /** 策略等级配置 */
    @ApiModelProperty("策略等级配置")
    private List<BusinessStrategyGradeSettingVO> strategyGradeList;

    /** 策略指标配置 */
    @ApiModelProperty("策略指标配置")
    private List<BusinessStrategyIndexSettingVO> strategyIndexList;

    /** 策略范围-指定业务伙伴 */
    @ApiModelProperty("策略范围-指定业务伙伴")
    private List<BusinessStrategyRefVO> strategyBusinessRefList;

    /** 策略范围-自定义范围 */
    @ApiModelProperty("策略范围-自定义范围")
    private List<BusinessStrategyRangeSettingVO> strategyRangeSettingList;
}
