package com.elitesland.tw.tw5.api.prd.personplan.query;


import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;


/**
 * 项目沟通计划query
 * @author wangxl
 * @date 2024/4/1
 */
@Data
@ApiModel(description = "项目沟通计划query")
public class PmsCommunicatePlanQuery extends TwQueryParam {

    /**
     * 沟通议程
     */
    @ApiModelProperty("沟通议程")
    private String title;

    /**
     * 关联计划
     */
    @ApiModelProperty("关联计划")
    private Long wbsId;

    /**
     * 关联计划
     */
    @ApiModelProperty("关联计划")
    private String wbsName;

    /**
     * 计划沟通时间
     */
    @ApiModelProperty("计划沟通时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime communicateTime;

    /**
     * 参与人
     */
    @ApiModelProperty("参与人")
    private String processingUser;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer status;

    /**
     * 处理时间
     */
    @ApiModelProperty("处理时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime processingTime;

    /**
     * 提醒提前时间(min)
     */
    @ApiModelProperty("提醒提前时间(min)")
    private String beforeRemindTime;

    /**
     * 沟通内容
     */
    @ApiModelProperty("沟通内容")
    private String content;

    /**
     * 提醒方式
     */
    @ApiModelProperty("提醒方式")
    private String remindMode;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long proId;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private List<Long> proIdList;
}