package com.elitesland.tw.tw5.api.prd.personplan.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目角色分配
 *
 * @author xxb
 * @date 2023-07-07
 */
@Getter
@Setter
public class PmsProjectRoleAssignmentQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目角色主键")
    private Long projectRoleId;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * 项目名称 模糊
     */
    @ApiModelProperty("项目名称")
    private String projectName;
    /**
     * 项目编号 模糊
     */
    @ApiModelProperty("项目编号")
    private String projectCode;
    /**
     * 员工ID 精确
     */
    @ApiModelProperty("员工ID")
    private Long userId;
    /**
     * 员工编号 模糊
     */
    @ApiModelProperty("员工编号")
    private String employeeNo;
    /**
     * 员工名称 模糊
     */
    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("用户ID集合")
    private List<Long> userIds;

    @ApiModelProperty("项目编号或名称")
    private String projectKeyWord;

    @ApiModelProperty("员工编号或名称")
    private String employeeKeyWord;
}
