package com.elitesland.tw.tw5.api.prd.personplan.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.common.util.TreeInterface;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;


/**
  * 任务主档
  *
  * @author duwh
  * @date 2024-02-01
  */
@Getter
@Setter
public class TaskProVO extends BaseViewModel implements TreeInterface<TaskProVO>, Cloneable  {
    /** 父主键 */
    @ApiModelProperty("父主键")
    private Long parentId;

    // public Long getParentId() {
    //     if (parentId == null) {
    //         parentId = 0L;
    //     }
    //     return parentId;
    // }

    /**
     * 子任务计数
     */
    private Long childCount;
    /** 事由类型 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 事由id */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 活动清单主键 pms_project_wbs.id
     */
    private Long wbsId;
    /**
     * 活动清单名称
     */
    private String wbsName;
    /** 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE] */
    @ApiModelProperty("可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]")
    private String showScope;
    @UdcName(udcName = "PMS:TASK_PRO:SHOW_SCOPE", codePropName = "showScope")
    private String showScopeDesc;
    /** 任务编号 */
    @ApiModelProperty("任务编号")
    private String taskNo;
    /** 任务名称 */
    @ApiModelProperty("任务名称")
    private String taskName;
    /** 任务状态 */
    @ApiModelProperty("任务状态 udc[PMS:TASK_PRO:STATUS]")
    private String taskStatus;
    @UdcName(udcName = "PMS:TASK_PRO:STATUS", codePropName = "taskStatus")
    private String taskStatusDesc;
    /** 任务类别 */
    @ApiModelProperty("任务类别")
    private Long taskCategoryId;
    /** 任务类别名称 */
    @ApiModelProperty("任务类别名称")
    private String taskCategoryName;
    /**
     * 状态流id
     */
    private Long stateFlowId;
    // /**
    //  * 状态流名称(冗余）
    //  */
    // private String stateFlowName;

    //****** 状态流字段 start **************
    /**
     * 状态流状态
     * 状态 1开始2进行中3已完成
     */
    private Integer stateFlowState;
    private String stateFlowName;
    /**
     * 进度百分比
     */
    private BigDecimal progressPercentage;
    //****** 状态流字段 end **************

    /** 优先级 UDC[PMS:TASK_PRO:PRIORITY] */
    @ApiModelProperty("优先级 UDC[PMS:TASK_PRO:PRIORITY]")
    private String priority;
    @UdcName(udcName = "PMS:TASK_PRO:PRIORITY", codePropName = "priority")
    private String priorityDesc;
    /** 发包userId */
    @ApiModelProperty("发包userId")
    private Long disterUserId;
    /** 负责人userId */
    @ApiModelProperty("负责人userId")
    private Long directorUserId;
    /** 负责人用户名 **/
    @UdcName(udcName = "USER", codePropName = "directorUserId")
    private String directorUserName;
    /** 负责人相关方id pro_related_parties.id */
    @ApiModelProperty("负责人相关方id pro_related_parties.id")
    private Long directorRelatedPartiesId;
    /*
     * 负责人相关方名称
     */
    private String directorRelatedPartiesName;
    /** 费用承担bu_id */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /** 接收资源bu_id */
    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;
    /** 接收userId */
    @ApiModelProperty("接收userId")
    private Long receiverUserId;
    @UdcName(udcName = "USER", codePropName = "receiverUserId")
    private String receiverUserName;
    /** 资源来源类型 */
    @ApiModelProperty("资源来源类型")
    private String resSourceType;
    /** 预估工时 */
    @ApiModelProperty("预估工时")
    private BigDecimal predictWorkHours;
    /** 实际工时 */
    @ApiModelProperty("实际工时")
    private BigDecimal actualWorkHours;
    /** 完工百分比 */
    @ApiModelProperty("完工百分比")
    private BigDecimal finishRate;
    /** 计划开始日期 */
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    /** 计划结束日期 */
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    /** 实际开始日期 */
    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    /** 实际结束日期 */
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;
    /** 任务类型 */
    @ApiModelProperty("任务类型")
    private String taskType;
    /** 任务包关闭时间 */
    @ApiModelProperty("任务包关闭时间")
    private LocalDateTime closedTime;
    /** 发包日期 */
    @ApiModelProperty("发包日期")
    private LocalDate distDate;
    /** 系统自动建包 */
    @ApiModelProperty("系统自动建包")
    private Boolean autoCreateFlag;
    /** 描述内容 */
    @ApiModelProperty("描述内容")
    private String content;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 是否置顶 */
    @ApiModelProperty("是否置顶")
    private Boolean topFlag;
    /** 置顶操作时间 */
    @ApiModelProperty("置顶操作时间")
    private LocalDateTime topModifyTime;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /** 通用任务成员关系集合 */
    @ApiModelProperty("通用任务成员关系集合")
    private List<TaskMemberRefVO> taskMemberRefList;

    // 关注人(相关方)
    private List<Long> memberFollowIdList;
    private List<String> memberFollowNameList;
    private String memberFollowNames;

    public String getMemberFollowNames() {
        if (memberFollowNameList != null && memberFollowNameList.size() > 0) {
            memberFollowNames = memberFollowNameList.stream().collect(Collectors.joining(","));
        } else {
            memberFollowNames = "";
        }
        return memberFollowNames;
    }

    public String getMemberPartNames() {
        if (memberPartNameList != null && memberPartNameList.size() > 0) {
            memberPartNames = memberPartNameList.stream().collect(Collectors.joining(","));
        } else {
            memberPartNames = "";
        }
        return memberPartNames;
    }

    // 参与人（相关方））
    private List<Long> memberPartIdList;
    private List<String> memberPartNameList;
    private String memberPartNames;

    /**
     * 创建人相关方id
     */
    private Long createRelatedPartiesId;
    /**
     * 创建关联方名称
     */
    private String createRelatedPartiesName;

    private List<TaskProVO> children;


    @Override
    public void setChildren(List<TaskProVO> children) {
        this.children = children;
    }

    @Override
    public Object getParentCode() {
        return this.getParentId();
    }

    @Override
    public Object getCode() {
        return this.getId();
    }
}
