package com.elitesland.tw.tw5.api.prd.pms.budget.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * 预算明细表payload
 * @author duwh
 * @date 2024/3/7
*/
@Data
@ApiModel(description = "预算明细表payload")
public class PmsWbsBudgetDetailsPayload extends TwCommonPayload {

    @ApiModelProperty("主表 id pms_wbs_budget.id")
    private Long budgetId;

    @ApiModelProperty("wbs 活动主键")
    private Long wbsId;

    @ApiModelProperty("wbs 活动名称（冗余)")
    private String wbsName;
    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    @ApiModelProperty("wbs 活动状态(冗余)")
    private String wbsStatus;

    @ApiModelProperty("版本 id")
    private Long versionId;

    @ApiModelProperty("版本号")
    private Integer versionNo;

    @ApiModelProperty("项目id")
    private Long proId;

    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    @ApiModelProperty("资源成本")
    private BigDecimal resCost;

    @ApiModelProperty("当前分配预算")
    private BigDecimal allocatedResAmt;

    @ApiModelProperty("剩余")
    private BigDecimal remainingResAmt;

    @ApiModelProperty("已占用")
    private BigDecimal occupiedResAmt;

    @ApiModelProperty("已结算")
    private BigDecimal settledResAmt;

    @ApiModelProperty("变更量")
    private BigDecimal changeResAmt;

    @ApiModelProperty("变更后分配预算")
    private BigDecimal changedAllocatedResAmt;

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

}
