package com.elitesland.tw.tw5.api.prd.pms.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;


import java.util.List;


/**
 * 预算版本表service
 *
 * @author duwh
 * @date 2024/3/7
 */
public interface PmsWbsBudgetVersionService {

    PmsWbsBudgetVersionVO getVersion(Long proId, String objStatus);

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    PagingVO<PmsWbsBudgetVersionVO> queryPage(PmsWbsBudgetVersionQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    List<PmsWbsBudgetVersionVO> queryList(PmsWbsBudgetVersionQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    long queryCount(PmsWbsBudgetVersionQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    PmsWbsBudgetVersionVO queryByKey(Long id);

    /**
     * 按项目id和版本号查询
     *
     * @param projectId 项目id
     * @param versionNo 版本号
     * @return {@link PmsWbsBudgetVersionVO}
     */
    PmsWbsBudgetVersionVO queryByProjectIdAndVersionNo(Long projectId, int versionNo);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVersionVO insert(PmsWbsBudgetVersionPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVersionVO update(PmsWbsBudgetVersionPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVersionVO updateDynamic(PmsWbsBudgetVersionPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    Long deleteSoft(List<Long> ids);

    /**
     * 获取pro-id和版本号
     *
     * @param proId         亲id
     * @param lastVersionNo 上次版本号
     * @return {@link PmsWbsBudgetVersionVO}
     */
    PmsWbsBudgetVersionVO getProIdAndVersionNo(Long proId, int lastVersionNo);

}
