package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 预算明细
 *
 * @author xxb
 * @date 2023-07-10
 */
@Getter
@Setter
public class PmsBudgetDetailPayload extends TwCommonPayload  implements Serializable {
    /** 预算id */
    @ApiModelProperty("预算id")
    private Long budgetId;

    /** 资源类型(labour人工、material材料、device设备) */
    @ApiModelProperty("资源类型(labour人工、material材料、device设备)")
    private String sourceType;
    /** 项目角色主键 */
    @ApiModelProperty("项目角色主键")
    private Long projectRoleId;
    /** 角色单价 */
    @ApiModelProperty("角色单价")
    private BigDecimal unitPrice;
    /** 平工期（天 */
    @ApiModelProperty("平工期（天")
    private BigDecimal days;
    /** 费用总预算 */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalMoney;
    /** 使用占比=已使用预算金额/预算总金额 */
    @ApiModelProperty("使用占比=已使用预算金额/预算总金额")
    private BigDecimal proportion;
    /** 已使用预算金额=已经报销完成的金额 */
    @ApiModelProperty("已使用预算金额=已经报销完成的金额")
    private BigDecimal usedMoney;
    /** 科目主键 */
    @ApiModelProperty("科目主键")
    private Long subjectId;
    /** 科目父主键 */
    @ApiModelProperty("科目父主键")
    private Long subjectParentId;
}
