package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * wbs活动成预估
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsWbsActCostQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    @Query
    private Long projectId;
    /**
     * wbs主键(仅活动类型) 精确
     */
    @ApiModelProperty("wbs主键(仅活动类型)")
    @Query
    private Long wbsId;
    /**
     * wbs描述（名称） 模糊
     */
    @ApiModelProperty("wbs描述（名称）")
    @Query(type = Query.Type.INNER_LIKE)
    private String wbsName;
    /**
     * 成本要素 模糊
     */
    @ApiModelProperty("成本要素")
    @Query(type = Query.Type.INNER_LIKE)
    private String costName;
    /**
     * 成本预估 模糊
     */
    @ApiModelProperty("成本预估")
    @Query(type = Query.Type.INNER_LIKE)
    private BigDecimal costEstimate;
}
