package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsActCostQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsActCostVO;


import java.util.List;

/**
 * wbs活动成预估
 *
 * @author carl
 * @date 2023-04-06
 */
public interface PmsWbsActCostService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsActCostVO}>
     */
    PagingVO<PmsWbsActCostVO> paging(PmsWbsActCostQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsWbsActCostVO}>
     */
    PagingVO<PmsWbsActCostVO> queryPaging(PmsWbsActCostQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsActCostVO}>
     */
    List<PmsWbsActCostVO> queryList(PmsWbsActCostQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsWbsActCostVO}>
     */
    List<PmsWbsActCostVO> queryListDynamic(PmsWbsActCostQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsWbsActCostVO}
     */
    PmsWbsActCostVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsWbsActCostVO}
     */
    PmsWbsActCostVO insert(PmsWbsActCostPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsWbsActCostVO}
     */
    PmsWbsActCostVO update(PmsWbsActCostPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
