package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
  * 预算科目明细
  *
  * @author Echo
  * @date 2023-04-24
  */
@Getter
@Setter
public class PmsBudgetTemplateSubjectVO extends BaseViewModel implements Serializable {
    /** 模板主键 */
    @ApiModelProperty("模板主键")
    private Long templateId;
    /** 科目id */
    @ApiModelProperty("科目id")
    private Long subjectId;
    /** 预算科目编号 */
    @ApiModelProperty("预算科目编号")
    private String subjectCode;
    /** 预算科目名称 */
    @ApiModelProperty("预算科目名称")
    private String subjectName;
    /** 上一级科目即父主键 */
    @ApiModelProperty("上一级科目即父主键")
    private Long parentId;
    /** 上一级科目即父名称 */
    @ApiModelProperty("上一级科目即父名称")
    private String parentName;
    /**
     * 科目状态
     */
    @ApiModelProperty("科目状态 0正常  1弃用")
    private Integer subjectStatus;

    /**
     * 层级
     */
    @ApiModelProperty("层级")
    private Integer subjectLevel;

    /** 费用总预算 */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalMoney;
}
