package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Getter
@Setter
public class PurchaseAgreementResQuery extends TwQueryParam implements Serializable{
    /**  精确 */
    @ApiModelProperty("")
    private Long id;
    /** 资源ID 精确 */
    @ApiModelProperty("资源ID")
    private Long resId;
    /** 采购协议单据ID 精确 */
    @ApiModelProperty("采购协议单据ID")
    private Long documentId;
    /** 采购协议单据编号 精确 */
    @ApiModelProperty("采购协议单据编号")
    private String documentNo;
    /** 资源开始日期 精确 */
    @ApiModelProperty("资源开始日期")
    private LocalDate resStartDate;
    /** 资源结束日期 精确 */
    @ApiModelProperty("资源结束日期")
    private LocalDate resEndDate;
    /** 合作方式 */
    @ApiModelProperty("合作方式")
    private String cooperationWay;
}
