package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
public interface SettleApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link SettleApplyVO}>
     */
    PagingVO<SettleApplyVO> queryPaging(SettleApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SettleApplyVO}>
     */
    List<SettleApplyVO> queryListDynamic(SettleApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link SettleApplyVO}
     */
    SettleApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SettleApplyVO}
     */
    SettleApplyVO insert(SettleApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SettleApplyVO}
     */
    SettleApplyVO update(SettleApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(SettleApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
