package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemSelectionService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemSelectionVO insert(PrdSystemSelectionPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemSelectionPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemSelectionVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemSelectionVO> paging(PrdSystemSelectionQuery query);

    /**
     * 通过KEY查询直属子集
     *
     * @param key 下拉选择key
     * @return
     */
    List<PrdSystemSelectionVO> selectByCondition(String key);

    List<PrdSystemSelectionVO> queryList(PrdSystemSelectionQuery query);

    /**
     * 根据父节点key查询子节点list，可以对子节点进行过滤
     * @param query 父节点key，及子节点过滤条件
     * @return
     */
    List<PrdSystemSelectionVO> getSystemSelectionChildrenList(PrdSystemSelectionQuery query);
}
