package com.elitesland.tw.tw5.api.prd.task.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 节点任务
 *
 * @author xxb
 * @date 2023-07-11
 */
@Getter
@Setter
public class PmsWbsTaskQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 项目主键 精确 */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /** wbs主键 精确 */
    @ApiModelProperty("wbs主键")
    private Long wbsId;
    /** 发包人id 精确 */
    @ApiModelProperty("发包人id")
    private Long disterUserId;
    /** 接包人id 精确 */
    @ApiModelProperty("接包人id")
    private Long receiverUserId;
    /** 任务编号 模糊 */
    @ApiModelProperty("任务编号")
    private String taskCode;
    /** 任务名称 模糊 */
    @ApiModelProperty("任务名称")
    private String taskName;
    /** 任务状态 精确 */
    @ApiModelProperty("任务状态")
    private String taskStatus;
    /** 任务开始时间 精确 */
    @ApiModelProperty("任务开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /** 任务结束时间 精确 */
    @ApiModelProperty("任务结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;
    /** 派发人天 精确 */
    @ApiModelProperty("派发人天")
    private BigDecimal days;
    /** 角色主键 精确 */
    @ApiModelProperty("角色主键")
    private Long projectRoleId;

    /**
     * 项目名称 模糊
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /** 资源类型(labour人工、material材料、device设备) */
    @ApiModelProperty("资源类型(labour人工、material材料、device设备)")
    private String sourceType;

    /**
     * 任务状态类型 0是不相等，1是相等
     */
    private String taskStatusType;

    /**
     * 任务状态
     */
    private String[] taskStatusList;

    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private Long managerUserId;
}
