package com.elitesland.tw.tw5.api.prd.task.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
public class TaskInfoQuery extends TwQueryParam implements Serializable {

    @ApiModelProperty("主键集合")
    private Collection<Long> idList;
    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @ApiModelProperty("任务包ID")
    private Long taskPackageId;
    @ApiModelProperty("任务包名称")
    private String taskPackageName;
    @ApiModelProperty("任务编号")
    private String taskNo;
    @ApiModelProperty("任务名称")
    private String taskName;
    @ApiModelProperty("任务负责人")
    private Long taskResId;
    @ApiModelProperty("协助人")
    private Long assId;
    @ApiModelProperty("关联活动")
    private Long relatedActId;
    @ApiModelProperty("关联活动")
    private String relatedAct;
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    @ApiModelProperty("任务类型")
    private String taskType;
    @ApiModelProperty("任务描述")
    private String taskDes;
    @ApiModelProperty("任务验收标准")
    private String accepCriteria;
    @ApiModelProperty("优先级")
    private Integer priority;
    @ApiModelProperty("任务总当量数")
    private BigDecimal totalEqva;
    @ApiModelProperty("已结算当量数")
    private BigDecimal settledEqva;
    @ApiModelProperty("计划当量数")
    private BigDecimal planEqva;
    @ApiModelProperty("追加当量数")
    private BigDecimal additionEqva;
    @ApiModelProperty("拆分当量数")
    private BigDecimal splitEqva;
    @ApiModelProperty("已使用当量")
    private BigDecimal usedEqva;
    @ApiModelProperty("有效当量数")
    private BigDecimal validEqva;
    @ApiModelProperty("是否评价:1已经评价过 0没有")
    private Integer evaluationflag;
    @ApiModelProperty("任务进度")
    private BigDecimal taskProgress;
    @ApiModelProperty("状态标记:0不等")
    private Integer taskStatusFlag;
    @ApiModelProperty("任务状态")
    private String taskStatus;
    @ApiModelProperty("任务状态集合")
    private List<String> taskStatuss;
    @ApiModelProperty("是否接收人")
    private Integer receiverFlag;

    @ApiModelProperty("是否发起人")
    private Integer initiatorFlag;

    @ApiModelProperty("是否逾期标记 1逾期  0不逾期  空全部")
    private Integer overdue;

    @ApiModelProperty("任务申请标记")
    private Integer taskApplyFlag;

    @ApiModelProperty("任务申请流程Id")
    private String taskApplyProcessId;

    @ApiModelProperty("任务负责人集合")
    private List<Long> taskResIds;

    @ApiModelProperty(value = "验收人")
    private Long acceptorId;
    /**
     * 占用查询标记：1占用查询
     */
    @ApiModelProperty("占用查询标记")
    private Integer occupyFlag;
    /**
     * 查询类型：1我接收的，2我派发的
     */
    @ApiModelProperty("查询类型")
    private Integer searchType;

    @ApiModelProperty("派发资源id")
    private Long disterResId;

    /**
     * 需要权限
     */
    private Boolean permissionFlag = false;

    //合同项目ids
    private List<Long> pmsProjIds;
    //BU项目ids
    private List<Long> buProjIds;
    //商机项目ids
    private List<Long> oppProjIds;

    @ApiModelProperty("任务来源类型null或1是普通任务，2奖励假任务,3帮我吧工时创建")
    private String sourceType;
    @ApiModelProperty("来源id（如果是奖励假申请则是奖励假申请id）")
    private Long sourceId;

    /**
     * 任务场景id(任务类别)
     */
    @ApiModelProperty("任务场景id")
    private Long taskSceneId;

    /**
     * 状态流id
     */
    @ApiModelProperty("状态流id")
    private Long stateFlowId;

    /**
     * 状态流id
     */
    @ApiModelProperty("状态流id")
    private List<Long> stateFlowIds;


    @ApiModelProperty("状态流编码")
    private String stateFlowCode;


    @ApiModelProperty("状态流版本")
    private Integer stateFlowVersionNo;

    /**
     * 项目分组ID
     */
    @ApiModelProperty("项目分组ID")
    private Long groupId;

    /**
     * 是否是未分组
     */
    @ApiModelProperty("是否是未分组")
    private Boolean groupFlag;

    /**
     * 上级员工ID
     */
    @ApiModelProperty("上级员工ID")
    private Long superiorsUserId;

    /**
     * 组织集合
     */
    @ApiModelProperty("组织集合")
    private List<Long> orgIdList;

    @ApiModelProperty("负荷率开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate loadRateStartDate;

    @ApiModelProperty("负荷率结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate loadRateEndDate;
}
