package com.elitesland.tw.tw5.api.prd.task.vo;

import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
 * 任务路线图明细VO
 * @author wangxl
 * @date 2024/4/28
 */
@Data
@ApiModel(description = "任务路线图明细vo")
public class PmsTaskRouteDtlVO extends TwCommonVO implements Serializable {

    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    @ApiModelProperty("任务id名称")
    private String taskIdDesc;

    /**
     * 执行项说明
     */
    @ApiModelProperty("执行项说明")
    private String executionDesc;

    /**
     * 上级id
     */
    @ApiModelProperty("上级id")
    private Long parentId;
    @ApiModelProperty("上级id名称")
    private String parentIdDesc;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;
    @ApiModelProperty("项目id名称")
    private String projectIdDesc;

    /**
     * 路线图id
     */
    @ApiModelProperty("路线图id")
    private Long masId;
    @ApiModelProperty("路线图id名称")
    private String masIdDesc;


    // 任务信息

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务编号")
    private String taskNo;

    /**
     * 状态流id
     */
    @ApiModelProperty("状态流id")
    private Long stateFlowId;
    private String stateFlowName;

    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;

    @ApiModelProperty("任务负责人")
    private Long taskResId;

    @UdcName(udcName = "USER", codePropName = "taskResId")
    @ApiModelProperty("任务负责人")
    private String taskRes;


    @ApiModelProperty("任务描述")
    private String taskDes;

    @ApiModelProperty("优先级")
    private Integer priority;


    @ApiModelProperty("子集集合")
    private List<PmsTaskRouteDtlVO> children;
}