package com.elitesland.tw.tw5.api.prd.task.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

@Data
public class TaskInfoCountVO {

    @ApiModelProperty("总任务数")
    private BigDecimal totalNum = BigDecimal.ZERO;

    @ApiModelProperty("总任务")
    private List<TaskInfoVO> totalTaskInfoVOList;

    @ApiModelProperty("已完成任务数")
    private BigDecimal completeNum = BigDecimal.ZERO;

    @ApiModelProperty("已完成任务")
    private List<TaskInfoVO> completeTaskInfoVOList;

    @ApiModelProperty("未完成任务数")
    private BigDecimal unCompleteNum = BigDecimal.ZERO;

    @ApiModelProperty("未完成任务")
    private List<TaskInfoVO> unCompleteTaskInfoVOList;

    @ApiModelProperty("已逾期任务数")
    private BigDecimal overdueNum = BigDecimal.ZERO;

    @ApiModelProperty("已逾期任务")
    private List<TaskInfoVO> overdueTaskInfoVOList;

    @ApiModelProperty("今日到期任务数")
    private BigDecimal todayOverNum = BigDecimal.ZERO;

    @ApiModelProperty("今日到期任务")
    private List<TaskInfoVO> todayOverTaskInfoVOList;

    @ApiModelProperty("逾期完成任务数")
    private BigDecimal overdueCompleteplNum = BigDecimal.ZERO;

    @ApiModelProperty("未到期任务数")
    private BigDecimal notYetDueNum = BigDecimal.ZERO;

    @ApiModelProperty("未来一天到期任务数")
    private BigDecimal tomorrowOverNum = BigDecimal.ZERO;

    @ApiModelProperty("员工数据统计")
    private List<TaskInfoUserInfoVO> taskInfoUserInfoVOList;

    @ApiModelProperty("近一周的任务燃尽/任务累积完成趋势")
    private List<TaskInfoLastWeekCountVO> taskInfoLastWeekCountVOList;

    @Data
    public static class TaskInfoUserInfoVO {
        @ApiModelProperty("员工名称")
        private String userName;

        @ApiModelProperty("员工及时率")
        private BigDecimal ratio;

        @ApiModelProperty("员工ID")
        private Long userId;

        @ApiModelProperty("任务数占比")
        private BigDecimal taskInfoOccupyRatio;

        @ApiModelProperty("未到期数量")
        private BigDecimal notYetDueNum;

        @ApiModelProperty("已逾期数量")
        private BigDecimal overDueNum;

        @ApiModelProperty("逾期完成数量")
        private BigDecimal overDueCompletedNum;

        @ApiModelProperty("员工负荷率")
        private BigDecimal loadRatio;

    }

    @Data
    public static class TaskInfoLastWeekCountVO {

        @ApiModelProperty("日期")
        private LocalDate currentDate;

        @ApiModelProperty("剩余任务数")
        private BigDecimal remainingNum = BigDecimal.ZERO;

        @ApiModelProperty("任务总数")
        private BigDecimal totalNum = BigDecimal.ZERO;

        @ApiModelProperty("完成数量")
        private BigDecimal completedNum = BigDecimal.ZERO;

    }


}
