package com.elitesland.tw.tw5.api.prd.task.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
public class TaskProBoardVO implements Serializable {

    private Integer state;
    private String stateName;

    private Long stateFlowId;
    private String stateFlowCode;

    private String name;
    /**
     * 字体颜色
     */
    @ApiModelProperty("字体颜色")
    private String fontColor;

    /**
     * 背景色
     */
    @ApiModelProperty("背景色")
    private String backgroundColor;

    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private Long versionId;


    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * 进度百分比
     */
    @ApiModelProperty("进度百分比")
    private BigDecimal progressPercentage;

    /**
     * 任务列表
     */
    List<TaskInfoVO> taskList;

    public String getStateName() {
        if (state != null) {
            if (state == 1) {
                return "开始状态";
            } else if (state == 2) {
                return "进行中";
            } else if (state == 3) {
                return "已结束";
            }
        }
        return stateName;
    }
}
