package com.elitesland.tw.tw5.api.common.funConfig.dto;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 页面配置 json dto
 *
 * @author duwh
 * @date 2023/06/28
 */
@Getter
@Setter
public class BusinessPageJsonDTO {

    private String id;
    /** 字段名称  示例： 名称 */
    private String title;
    /** 组件类型 BusinessPageComponentTypeEnum  */
    private String type;
    /** 字段 key 示例：name */
    private String name;
    /** 默认值 示例：张三 */
    private String defaultValue = "";

    private String businessKey;
    private String businessApi;

    /**
     * 表单布局列数
     */
    private Integer formLayout;

    /** 是否可清除 */
    private Boolean clearable = true;
    /** true 多选  false单选 */
    private Boolean multiple = false;
    /** 最大长度 */
    private Integer maxLength;
    /** 占位符 */
    private String placeholder;
    /** 描述 */
    private String description;
//    /** 是否隐藏  后续迭代 支持表达式 ${xxx} */
//    private Boolean hidden = true;
    /** 是否展示 支持表达式 ${xxx} */
    private Object show = false;

    public Object getShow() {
        if (ObjectUtils.isEmpty(show)) {
            return false;
        } else if (show.equals("true") || show.toString().contains("true")) {
            return true;
        } else if (show.toString().contains("$")) {
            return show;
        } else {
            return false;
        }
    }

    /**  */
    private String showMode;
    /** 是否只读 */
    private Boolean readOnly = false;
    /** 是否禁用 */
    private Boolean disabled = false;
    /** 是否必填 */
    private Boolean required = false;

    /** 能否添加下级的字段 */
    private Boolean addChild = false;
    /** 系统选择项key */
    private String udcKey;
    /** 自定义下拉选择接口地址 */
    private String customSelectUri;
    /** 排序字段 */
    private Integer sortNo = 0;
    /**
     * 表达式回显
     */
    private String expressionEcho;
    /** 下级组件  */
    List<BusinessPageJsonDTO> body;

}
