package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.TableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.TableInfo;

import java.util.List;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
public interface BusinessTableService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessTableVO}>
     */
    PagingVO<BusinessTableVO> queryPaging(BusinessTableQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessTableVO}>
     */
    List<BusinessTableVO> queryListDynamic(BusinessTableQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessTableVO}
     */
    BusinessTableVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessTableVO}
     */
    BusinessTableVO insert(BusinessTablePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessTableVO}
     */
    BusinessTableVO update(BusinessTablePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessTablePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    PagingVO<TableInfo> tables(TableQuery query);

    void generator(Long id,String projectModule,
                   String apiGorupName,
                   String packageName,
                   String author,
                   String moduleName,
                   String prefix,
                   boolean cover);

    List<BusinessTableVO> listAll(BusinessTableQuery query);
}
