package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 差旅报销额度管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Getter
@Setter
public class AccReimTripStdQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * P职级区间下限
     */
    @ApiModelProperty("P职级区间下限")
    private String jobGradePlLow;
    /**
     * P职级区间上限
     */
    @ApiModelProperty("P职级区间上限")
    private String jobGradePlUp;
    /**
     * M职级区间下限
     */
    @ApiModelProperty("M职级区间下限")
    private String jobGradeMlLow;
    /**
     * M职级区间上限
     */
    @ApiModelProperty("M职级区间上限")
    private String jobGradeMlUp;
    /**
     * 费用类型
     */
    @ApiModelProperty("费用类型 MEAL-餐费 HOTEL-住宿")
    private String feeType;
    /**
     * 城市级别 精确
     */
    @ApiModelProperty("城市级别")
    private String cityLevel;
    /**
     * 项目报销级别 精确
     */
    @ApiModelProperty("项目报销级别")
    private Integer projectFeeLevel;
    /**
     * 报销额度 精确
     */
    @ApiModelProperty("报销额度")
    private BigDecimal feeAmt;

    @ApiModelProperty("职级")
    private String jobGrade;

    @ApiModelProperty("费用承担方")
    private String expenseByType;
}
