package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmCustomerOperationQuery extends TwQueryParam {


    /**
     * 客户表主键
     */
    @Query()
    private Long customerId;

    /**
     * 客户表主键
     */
    @Query(type = Query.Type.IN, propName = "customerId")
    private List<Long> customerIdList;

    /**
     * 客户经营编号
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String custNo;

    /**
     * 类型 udc
     */
    @Query()
    private String custType;

    /**
     * 客户经营状态
     */
    @Query
    private String custOperStatus;

    /**
     * 第三方公司主键：天眼查id or 启信宝id
     */
    @Query()
    private String threeId;

    /**
     * 第三方公司类型：天眼查:TYC or 启信宝:QXB
     */
    @Query()
    private String threeType;

    /**
     * 名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String custName;

    /**
     * 公司性质 udc
     */
    @Query()
    private String custNature;

    /**
     * 行业 udc
     */
    @Query()
    private String custIndustry;

    /**
     * 母公司主键
     */
    @Query()
    private Long parentId;

    /**
     * 母公司名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String parentCompany;

    /**
     * 网址
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String website;

    /**
     * 座机
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String landline;

    /**
     * 邮箱
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String email;

    /**
     * 省
     */
    @Query()
    private String province;

    /**
     * 省名字
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String provinceName;

    /**
     * 城市
     */
    @Query()
    private String city;

    /**
     * 城市名字
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String cityName;

    /**
     * 区
     */
    @Query()
    private String district;

    /**
     * 地区名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String districtName;

    /**
     * 地址
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String custAddress;

    /**
     * 客户级别 udc
     */
    @Query()
    private String custGrade;

    /**
     * 销售规模
     */
    @Query()
    private BigDecimal saleScale;

    /**
     * 行业地位 udc
     */
    @Query()
    private String industryStand;

    /**
     * 数字化投入力度 udc
     */
    @Query()
    private String digitalInvestment;

    /**
     * 与公司紧密度 udc
     */
    @Query()
    private String companyTightness;

    /**
     * 历史合作产出（万元）
     */
    @Query()
    private BigDecimal historyCooOutput;

    /**
     * 销售经营部门
     */
    @Query()
    private Long saleOperBu;

    /**
     * 销售经营部门
     */
    @Query(type = Query.Type.IN, propName = "saleOperBu")
    private List<Long> saleOperBuList;

    /**
     * 是否包含销售经营部门子部门
     */
    private Boolean subSaleOperBuFlag;

    /**
     * 销售经营部负责人
     */
    @Query()
    private Long saleOperManagerId;

    /**
     * 客户经营部门
     */
    @Query()
    private Long custOperBu;

    /**
     * 是否包含客户经营部门子部门
     */
    private Boolean subCustOperBuFlag;

    /**
     * 客户经营部门
     */
    @Query(type = Query.Type.IN, propName = "custOperBu")
    private List<Long> custOperBuList;

    /**
     * 客户经营部负责人
     */
    @Query()
    private Long custOperManagerId;

    /**
     * 经营策略 udc
     */
    @Query()
    private String businessStrategy;

    /**
     * 主营业务 udc[crm:cust_oper:main_business]
     */
    @Query()
    private String mainBusiness;

    /**
     * 销售覆盖
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String saleCover;

    /**
     * 合作形式 udc[crm:cust_oper:coop_type]
     */
    @Query()
    private String coopType;

    /**
     * 合作等级
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String coopLevel;

    /**
     * 渠道经营部门
     */
    @Query()
    private Long channelBu;

    /**
     * 渠道经营负责人
     */
    @Query()
    private Long channelUserId;

    /**
     * 产品负责人
     */
    @Query()
    private Long productUserId;

    /**
     * 生态伙伴业务简述
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ecoDescription;

    /**
     * 客户企业 业务简述
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String custDescription;

    /**
     * 组织及协会简述
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String orgAssDescription;

    /**
     * 创建时间筛选项
     * 起止时间都传一个里面
     * createTime: 2022-11-01 00:00:00
     * createTime: 2022-11-03 23:59:59
     */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private List<LocalDateTime> createTime;

    /**
     * 服务负责人
     */
    @Query()
    private Long serviceUserId;

    /**
     * 商务负责人
     */
    @Query()
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    @Query()
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    @Query()
    private Long operationUserId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 是否级联查询
     */
    private Boolean treeSearch;

    /**
     * id集合  英文逗号隔开；
     */
    private String idListStr;
    /**
     * id集合
     */
    @Query(type = Query.Type.IN, propName = "id")
    private List<Long> idList;

    /**
     * 按主键筛选数据
     */
    @Query(type = Query.Type.EQUAL, propName = "id")
    private Long idPro;

    /**
     * 拓展1
     */
    private String ext1;

    /**
     * 拓展2
     */
    private String ext2;

    /**
     * 拓展3
     */
    private String ext3;

    /**
     * 拓展4
     */
    private String ext4;

    /**
     * 拓展5
     */
    private String ext5;

}
