package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.util.List;

/**
 * 客户经营-经营人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Data
public class CrmPeopleQuery extends TwQueryParam {

    /**
     * 客户经营主键
     */
    @Query
    private Long operId;

    /**
     * 客户表主键
     */
    private Long customerId;
    /**
     * 名称
     */
    private String peopleName;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 状态
     */
    private String peopleStatus;
    /**
     * 部门
     */
    private String bu;
    /**
     * 岗位
     */
    private String jobs;
    /**
     * 行业
     */
    private String industry;
    /**
     * 微信
     */
    private String weChat;
    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;
    /**
     * 人脉地址-详细地址
     */
    private String locationDetail;

    /**
     * 人脉id列表
     */
    private Long[] peopleIds;
    /**
     * 拥有的客户经营权限ids
     */
    private List<Long> operIds;
    /**
     * 拥有的客户经营权限ids
     */
    private List<Long> customerIds;
    /**
     * 不需要权限
     */
    private Boolean noPermissionFlag = false;

}
