package com.elitesland.tw.tw5.api.prd.humanresources.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

@Data
public class ResourcePlanQuery extends TwQueryParam {

    @ApiModelProperty("展示内容")
    private List<String> showItems;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("开始时间")
    private LocalDate planStartDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("结束时间")
    private LocalDate planEndDate;

    @ApiModelProperty("项目")
    private Long projectId;

    @ApiModelProperty("视角, 1:项目 2:资源经理 3:资源上级 4:部门 5:全局")
    private Integer type;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("上级")
    private Long parentId;

    @ApiModelProperty("部门")
    private Long orgId;

    @ApiModelProperty("部门")
    private List<Long> orgIdList;
    @ApiModelProperty("资源经理")
    private Long resManageId;

    @ApiModelProperty("区域")
    private String baseBu;

    @ApiModelProperty("资源类型一")
    private String resType1;

    @ApiModelProperty("资源类型二")
    private String resType2;
}
