package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigDtlVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置明细表Service
 */
 
public interface PrdEvaluateConfigDtlService {
    
    /**
     * 新增评价配置明细表数据
     * @param prdEvaluateConfigDtlPayload
     * @return
     */
    PrdEvaluateConfigDtlVO save(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload);
    
     /**
     * 根据主键更新
     * @param prdEvaluateConfigDtlPayload
     * @return
     */
    PrdEvaluateConfigDtlVO update(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdEvaluateConfigDtlVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdEvaluateConfigDtlQuery
     * @return
     */
    PagingVO<PrdEvaluateConfigDtlVO> page(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdEvaluateConfigDtlQuery
      * @return
      */
     List<PrdEvaluateConfigDtlVO> getList(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery);
    
        /**
      * 根据条件修改
      * @param prdEvaluateConfigDtlPayload
      * @return
      */
     Long updateByCondition(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload);

     /**
      * 根据配置id删除
      * @param id
      * @return
      */
     Long delByConfigId(Long id);
 }

