package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Setter
public class RewardLeaveApplyDetailQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 申请单id 精确
     */
    @ApiModelProperty("申请单id")
    private Long applyId;
    /**
     * 资源userId 精确
     */
    @ApiModelProperty("资源userId")
    private Long userId;
    /**
     * 职级 精确
     */
    @ApiModelProperty("职级")
    private String jobGrade;
    /**
     * 资源组织Id 精确
     */
    @ApiModelProperty("资源组织Id")
    private Long orgId;
    /**
     * 工作日期 精确
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作类型 精确
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 奖励假天数 精确
     */
    @ApiModelProperty("奖励假天数")
    private BigDecimal days;
    /**
     * 理论当量 精确
     */
    @ApiModelProperty("理论当量")
    private BigDecimal eqva;
    /**
     * 已申请天数 精确
     */
    @ApiModelProperty("已申请天数")
    private BigDecimal appliedDays;


    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    private Long reasonId;

}