package com.elitesland.tw.tw5.api.prd.partner.business.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;


/**
  * 客户账号授权
  *
  * @author wangly
  * @date 2024-12-05
  */
@Getter
@Setter
public class BusinessPartnerAccreditVO extends BaseViewModel implements Serializable {
    /** 业务伙伴bookId */
    @ApiModelProperty("业务伙伴bookId")
    private Long bookId;
    /** 授权账号 */
    @ApiModelProperty("授权账号")
    private String account;
    /** 密码 */
    @ApiModelProperty("密码")
    private String password;
    /** 授权状态 */
    @ApiModelProperty("授权状态")
    private String accreditStatus;
    /** 授权结束日期 */
    @ApiModelProperty("授权结束日期")
    private LocalDate accreditEndDate;
    /** 授权操作人ID */
    @ApiModelProperty("授权操作人ID")
    private LocalDate operationId;
    /** 用户id */
    @ApiModelProperty("用户id")
    private Long userId;
    /** 员工表id */
    @ApiModelProperty("员工表id")
    private Long employeeId;
    /** 项目关联数据 */
    @ApiModelProperty("项目关联数据")
    private List<AccreditProjectRefVO> accreditProjectRefVOS;
}
