package com.elitesland.tw.tw5.api.prd.partner.strategy.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 分级策略业务伙伴映射关系
 *
 * @author wanlgy
 * @date 2023-06-19
 */
@Getter
@Setter
public class BusinessStrategyRefQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 分级策略id business_strategy.id 精确 */
    @ApiModelProperty("分级策略id business_strategy.id")
    private Long strategyId;
    /** 业务伙伴id business_partner.id 精确 */
    @ApiModelProperty("业务伙伴id business_partner.id")
    private Long partnerId;
    /** 选项分数 精确 */
    @ApiModelProperty("选项分数")
    private Integer optionScore;
    /** 排序号 精确 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
