package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 预算科目
 *
 * @author xxb
 * @date 2023-04-23
 */
@Getter
@Setter
public class PmsBudgetSubjectPayload extends TwCommonPayload implements Serializable {
    /**
     * 科目编号
     */
    @ApiModelProperty("科目编号")
    private String subjectCode;
    /**
     * 科目名称
     */
    @ApiModelProperty("科目名称")
    private String subjectName;
    /**
     * 上一级科目即父主键
     */
    @ApiModelProperty("上一级科目即父主键")
    private Long parentId;
    /**
     * 上一级科目即父名称
     */
    @ApiModelProperty("上一级科目即父主键")
    private String parentName;
    /**
     * 层级
     */
    @ApiModelProperty("层级")
    private Integer subjectLevel;

    /**
     * 科目状态
     */
    @ApiModelProperty("科目状态 0正常  1弃用")
    private Integer subjectStatus;

}
