package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目活动
 *
 * @author xxb
 * @date 2023-08-17
 */
@Getter
@Setter
public class PmsProjectActivityQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;

    /**
     * 父级阶段id
     */
    @ApiModelProperty("父级阶段id")
    private Long parentId;
    /**
     * 父级阶段编号
     */
    @Comment("父级阶段编号")
    @Column()
    private String parentNo;
    /**
     * 活动编号 精确
     */
    @ApiModelProperty("活动编号")
    private String actNo;
    /**
     * 活动名称 精确
     */
    @ApiModelProperty("活动名称")
    private String actName;
    /**
     * 是否里程碑标志 精确
     */
    @ApiModelProperty("是否里程碑标志")
    private Integer milestoneFlag;
    /**
     * 是否阶段标志 精确
     */
    @ApiModelProperty("是否阶段标志")
    private Integer phaseFlag;
    /**
     * 是否来自模板标志 精确
     */
    @ApiModelProperty("是否来自模板标志")
    private Integer fromtmplFlag;
    /**
     * 起日期 精确
     */
    @ApiModelProperty("起日期")
    private LocalDate startDate;
    /**
     * 止日期 精确
     */
    @ApiModelProperty("止日期")
    private LocalDate endDate;
    /**
     * 排序号 精确
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 工作台显示标志 精确
     */
    @ApiModelProperty("工作台显示标志")
    private Integer workbenchFlag;
    /**
     * 收款计划ID 精确
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;

    private List<Long> ids;

    /**
     * 初始换活动标记 精确
     */
    @ApiModelProperty("初始换活动标记")
    private Integer initFlag;
}
