package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCardConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectCardConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCardConfigVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectPageConfigVO;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 项目卡片配置
 *
 * @author wangly
 * @date 2024-12-02
 */
public interface PmsProjectCardConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectCardConfigVO}>
     */
    PagingVO<PmsProjectCardConfigVO> queryPaging(PmsProjectCardConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectCardConfigVO}>
     */
    List<PmsProjectCardConfigVO> queryListDynamic(PmsProjectCardConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectCardConfigVO}
     */
    PmsProjectCardConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectCardConfigVO}
     */
    PmsProjectCardConfigVO insert(PmsProjectCardConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectCardConfigVO}
     */
    PmsProjectCardConfigVO update(PmsProjectCardConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectCardConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查询页面配置
     *
     * @param query 条件参数
     */
    PmsProjectPageConfigVO queryPageConfigList(PmsProjectCardConfigQuery query);


    /**
     * 批量新增
     *
     * @param payloadList 单据数据
     * @return {@link PmsProjectCardConfigVO}
     */

    void saveAll(List<PmsProjectCardConfigPayload> payloadList);

}
