package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbIgnore;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class PmsProjectSimpleVO {

    @ApiModelProperty("主键")
    private Long id;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;

    /**
     * 完工百分比
     */
    @ApiModelProperty("完工百分比")
    private BigDecimal compPercent;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;

    @UdcName(udcName = "USER", codePropName = "pmResId")
    private String pmResName;

    /**
     * wbs里程碑（名称）
     */
    @ApiModelProperty("wbs里程碑（名称）")
    private String wbsMsName;

    /**
     * wbs阶段（名称）
     */
    @ApiModelProperty("wbs阶段（名称）")
    private String wbsActgName;

}
