package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 付款明细
 *
 * @author likunpeng
 * @date 2023-12-01
 */
@Getter
@Setter
public class PurchaseAgreementPaymentVO implements Serializable {

    /**
     * 付款计划表Id
     */
    @ApiModelProperty("付款计划表Id")
    private Long paymentPlanId;

    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;

    /** 付款金额 */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;

    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;

    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate estimatedPaymentDate;

    /** 付款状态 */
    @ApiModelProperty("付款状态")
    private String paymentStatus;
    @UdcName(udcName = "purchase:pay_status", codePropName = "paymentStatus")
    @ApiModelProperty("付款状态描述")
    private String paymentStatusDesc;

    /** 付款时间 */
    @ApiModelProperty("付款时间")
    private LocalDateTime paymentDate;

    /** 付款申请单Id */
    @ApiModelProperty("付款申请单Id")
    private Long paymentApplyId;

    /** 付款申请单编号 */
    @ApiModelProperty("付款申请单编号")
    private String paymentApplyNo;

    /** 付款申请单类型 */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;
    @UdcName(udcName = "purchase:payment_type", codePropName = "paymentApplicationType")
    private String paymentApplicationTypeDesc;

    /** 付款申请单状态 */
    @ApiModelProperty("付款申请单状态")
    private String paymentApplyStatus;
    @UdcName(udcName = "purchase:payment_status", codePropName = "paymentApplyStatus")
    private String paymentApplyStatusDesc;

    /** 已核销金额 */
    @ApiModelProperty("已核销金额")
    private BigDecimal alreadyWriteOffAmt;

    /** 核销单 */
    @ApiModelProperty("核销单")
    private List<WriteOffPaymentApplyVO> writeOffAmtPaymentApplyVOS;

}
