package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 销售合同-T&M-服务价格
 *
 * @author sam.li
 * @date 2024-05-07
 */
@Getter
@Setter
public class ConServicePricePayload extends TwCommonPayload  implements Serializable {
    /** 合同ID */
    @ApiModelProperty("合同ID")
    private Long saleConId;
    /** 结算周期 */
    @ApiModelProperty("结算周期")
    private String settlementCycle;
    /** 结算方式 */
    @ApiModelProperty("结算方式")
    private String settlementMethod;
    /** 角色 */
    @ApiModelProperty("角色")
    private String role;
    /** 级别 */
    @ApiModelProperty("级别")
    private String level;
    /** 人天单价 */
    @ApiModelProperty("人天单价")
    private BigDecimal priceDay;
}
