package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售合同执行情况管理
 *
 * @author sunxw
 * @date 2023-11-24
 */
@Getter
@Setter
public class SaleConExecConditionPayload extends TwCommonPayload implements Serializable {
    /**
     * 合同ID
     */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /**
     * 签单金额
     */
    @ApiModelProperty("签单金额")
    private BigDecimal signAmt;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 销售费用
     */
    @ApiModelProperty("销售费用")
    private BigDecimal saleExpense;
    /**
     * 项目费用
     */
    @ApiModelProperty("项目费用")
    private BigDecimal projExpense;
    /**
     * 合同采购金额
     */
    @ApiModelProperty("合同采购金额")
    private BigDecimal purchaseAmt;
    /**
     * 过单毛利
     */
    @ApiModelProperty("过单毛利")
    private BigDecimal overOrderGross ;
    /**
     * 部门毛利
     */
    @ApiModelProperty("部门毛利")
    private BigDecimal buGross;
    /**
     * 有效合同金额
     */
    @ApiModelProperty("有效合同金额")
    private BigDecimal effectConAmt;
    /**
     * 核算有效金额
     */
    @ApiModelProperty("核算有效金额")
    private BigDecimal calcEffectAmt;
    /**
     * 合同价格评级
     */
    @ApiModelProperty("合同价格评级")
    private String conPriceLevel;
    /**
     * 项目计算当量
     */
    @ApiModelProperty("项目计算当量")
    private BigDecimal calcProjEquiv;
    /**
     * 项目计算核定当量
     */
    @ApiModelProperty("项目计算核定当量")
    private BigDecimal calcCheckProjEquiv;
    /**
     * 最经济交付当量
     */
    @ApiModelProperty("最经济交付当量")
    private BigDecimal economicEquiv;
    /**
     * 项目执行当量
     */
    @ApiModelProperty("项目执行当量")
    private BigDecimal projExecEquiv;
    /**
     * 统计日期
     */
    @ApiModelProperty("统计日期")
    private LocalDate statisticDate;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 合同预算工作代办标志 true 可以查询待办 false 查询不到待办
     */
    @ApiModelProperty("合同预算工作代办标志 true 可以查询待办 false 查询不到待办")
    private Boolean workAgentFlag;

}
