package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Getter
@Setter
public class PrdSystemFinPeriodPayload extends TwCommonPayload  implements Serializable {
    /** 财务年度ID */
    @ApiModelProperty("财务年度ID")
    private Long finYearId;
    /** 财务年度 */
    @ApiModelProperty("财务年度")
    private Integer finYear;
    /** 财务期间 */
    @ApiModelProperty("财务期间")
    private Integer finPeriod;
    /** 期间名称 */
    @ApiModelProperty("期间名称")
    private String periodName;
    /** 期间状态 */
    @ApiModelProperty("期间状态")
    private String periodStatus;
    /** 开始日期 */
    @ApiModelProperty("开始日期")
    private LocalDate beginDate;
    /** 结束日期 */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
}
