package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * 科目模板管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Getter
@Setter
public class AccSubjectTemplateQuery extends TwQueryParam implements Serializable{
    /** 记录唯一id 精确 */
    @ApiModelProperty("记录唯一id")
    private Long id;
    /** 模板编号 模糊 */
    @ApiModelProperty("模板编号")
    private String tmplNo;
    /** 模板名称 模糊 */
    @ApiModelProperty("模板名称")
    private String tmplName;
    /** 适用行业 精确 */
    @ApiModelProperty("适用行业")
    private String tmplIndustry;
    /** 模板状态 精确 */
    @ApiModelProperty("模板状态")
    private String tmplStatus;
    /** 模板类别 精确 */
    @ApiModelProperty("模板类别")
    private String tmplClass;
    /** 适用类型 精确 */
    @ApiModelProperty("适用类型")
    private String tmplType;
    /** 预算控制级别 精确 */
    @ApiModelProperty("预算控制级别")
    private Integer budgetLevel;
    /** 控制策略 精确 */
    @ApiModelProperty("控制策略")
    private String controlType;
    /** 可配置字段1 精确 */
    @ApiModelProperty("可配置字段1")
    private String extStr1;
    /** 可配置字段2 精确 */
    @ApiModelProperty("可配置字段2")
    private String extStr2;
    /** 可配置字段3 精确 */
    @ApiModelProperty("可配置字段3")
    private String extStr3;
    /** 可配置字段4 精确 */
    @ApiModelProperty("可配置字段4")
    private String extStr4;
    /** 可配置字段5 精确 */
    @ApiModelProperty("可配置字段5")
    private String extStr5;

    private List<Long> inIds;
}
