package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
@Getter
@Setter
@ExcelIgnoreUnannotated
public class AccReimTaxVO extends BaseViewModel implements Serializable {
    /**
     * 报销单ID
     */
    @ApiModelProperty("报销单ID")
    private Long reimId;

    @ApiModelProperty("报销单明细id")
    private Long reimDtlId;

    @ApiModelProperty("报销单号")
    @ExcelProperty(index = 0, value = "报销单号")
    private String reimNo;

    @ApiModelProperty("报销人USER_ID")
    private Long reimUserId;
    @UdcName(udcName = "USER", codePropName = "reimUserId")
    @ExcelProperty(index = 1, value = "报销人")
    private String reimUserName;

    @ApiModelProperty("报销人ORG_ID")
    private Long reimOrgId;
    @UdcName(udcName = "BU", codePropName = "reimOrgId")
    private String reimOrgName;

    @ApiModelProperty("报销人职级")
    private String reimResGrade;

    @ApiModelProperty("单据类型")
    private String reimDocType;
    @UdcName(udcName = "ACC:REIM_PROC_KEY", codePropName = "reimDocType")
    @ExcelProperty(index = 10, value = "单据类型")
    private String reimDocTypeName;

    @ApiModelProperty("相关申请单")
    private Long relatedDocId;

    @ApiModelProperty("相关申请单名称")
    private String relatedDocName;

    @ApiModelProperty("相关预算")
    private Long relatedBudgetId;

    @ApiModelProperty("费用承担项目")
    private Long expenseProjectId;

    @ApiModelProperty("费用承担部门")
    private Long expenseOrgId;
    @UdcName(udcName = "BU", codePropName = "expenseOrgId")
    private String expenseOrgName;

    @ApiModelProperty("费用承担公司")
    private Long expenseCompany;
    private String expenseCompanyName;

    @ApiModelProperty("记账日期")
    private LocalDateTime accountingDate;

    @ApiModelProperty("报销单状态")
    private String reimStatus;
    @UdcName(udcName = "ACC:REIM_STATUS", codePropName = "reimStatus")
    private String reimStatusName;

    @ApiModelProperty("报销说明")
    @ExcelProperty(index = 8, value = "报销说明")
    private String reimRemark;

    @ApiModelProperty("事由类型")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeName;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("事由名称")
    private String reasonName;

    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private String payMode;
    @UdcName(udcName = "ACC:PAY_MODE", codePropName = "payMode")
    private String payModeName;

    @ApiModelProperty("客户承担费用")
    private String expenseByType;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "expenseByType")
    private String expenseByTypeName;

    @ApiModelProperty("审批状态")
    private String apprStatus;
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    private String apprStatusName;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("流程实例名称")
    private String procInstName;

    @ApiModelProperty("财务收单时间")
    private LocalDateTime finChargeUpTime;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    @ExcelProperty(index = 12, value = "记账批次号")
    private String batchNo;

    @ApiModelProperty("新批次号 作为付款时用，与记账做区分")
    private String batchNoLast;

    @ApiModelProperty("附件")
    private String fileCode;

    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    @ApiModelProperty("财务负责人审批时间")
    private LocalDateTime finPicApprTime;

    @ApiModelProperty("流程节点名称")
    @ExcelProperty(index = 11, value = "当前流程节点")
    private String apprProcName;

    /**
     * 会计科目
     */
    @ApiModelProperty("会计科目")
    private Long finAccSubjId;
    @ApiModelProperty("会计科目名称")
    @ExcelProperty(index = 2, value = "会计科目")
    private String finAccSubjName;

    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;

    @ExcelProperty(index = 7, value = "费用发生日期")
    private String expenseDateStr;

    public String getExpenseDateStr(){
        if(expenseDate!=null){
            return  expenseDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return expenseDateStr;
    }

    @ApiModelProperty("报销金额(含税)")
    @ExcelProperty(index = 3, value = "报销金额(含税)")
    private BigDecimal reimAmt;

    @ApiModelProperty("报销金额(不含税)")
    @ExcelProperty(index = 4, value = "报销金额(不含税)")
    private BigDecimal noTaxReimAmt;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    @ExcelProperty(index = 6, value = "税率")
    private BigDecimal taxRate;
    @UdcName(udcName = "prd:ab:tax_rate", codePropName = "taxRate")
    private String taxRateName;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    @ExcelProperty(index = 5, value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("发票集合")
    private List<InvInvoiceVO> invInvoiceList;

    @ExcelProperty(index = 9, value = "发票号")
    private String invInvoiceNo;

    public String getInvInvoiceNo(){
        if(!CollectionUtils.isEmpty(invInvoiceList)){
            return invInvoiceList.stream().filter(p -> StringUtils.hasText(p.getInvoiceNo())).map(s -> s.getInvoiceNo()).collect(Collectors.joining(","));
        }
        return invInvoiceNo;
    }
}
