package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalSettlePricePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalSettlePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalSettlePriceVO;

import java.util.List;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
public interface CalSettlePriceService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalSettlePriceVO}>
     */
    PagingVO<CalSettlePriceVO> queryPaging(CalSettlePriceQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalSettlePriceVO}>
     */
    List<CalSettlePriceVO> queryListDynamic(CalSettlePriceQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalSettlePriceVO}
     */
    CalSettlePriceVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalSettlePriceVO}
     */
    CalSettlePriceVO insertOrUpdate(CalSettlePricePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 精准匹配查询-获取价格
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalSettlePriceVO}>
     */
    CalSettlePriceVO getSettlePricePlus(CalSettlePriceQuery query);

}
