package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalWideSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;

import java.util.List;

/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
public interface CalWideSettleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalWideSettleVO}>
     */
    PagingVO<CalWideSettleVO> queryPaging(CalWideSettleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalWideSettleVO}>
     */
    List<CalWideSettleVO> queryListDynamic(CalWideSettleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalWideSettleVO}
     */
    CalWideSettleVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalWideSettleVO}
     */
    CalWideSettleVO insertOrUpdate(CalWideSettlePayload payload);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CalWideSettlePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link CalWideSettleVO}
//     */
//    CalWideSettleVO update(CalWideSettlePayload payload);

}
