package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;


/**
 * 当量收入配置变更记录
 *
 * @author wangly
 * @date 2024-02-22
 */
@Getter
@Setter
public class CalEqvaIncomeLogVO extends BaseViewModel implements Serializable {
    /**
     * 当量收入配置主键
     */
    @ApiModelProperty("当量收入配置主键")
    private Long relateId;
    /**
     * 单位当量收入
     */
    @ApiModelProperty("单位当量收入")
    private BigDecimal preeqvaAmt;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String lineStatus;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;

    /**
     * 资源id
     */
    @ApiModelProperty("资源名称")
    @UdcName(udcName = "USER", codePropName = "resId")
    private String resName;
    /**
     * 资源类型1内部，0外部
     */
    @ApiModelProperty("资源类型1内部，0外部")
    private String resType;
    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer version;
    /**
     * 起始日期
     */
    @ApiModelProperty("起始日期")
    private LocalDate startDate;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDate endDate;
    /**
     * 结算方式
     */
    @ApiModelProperty("结算方式 udc[org:employee:withdrawSettleMethod]")
    private String settleType;

    /**
     * 结算方式名称
     */
    @ApiModelProperty("结算方式名称 udc[org:employee:withdrawSettleMethod]")
    @UdcName(udcName = "org:employee:withdrawSettleMethod",codePropName = "settleType")
    private String settleTypeDesc;
}
