package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 当量收入配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalEqvaIncomeVO extends BaseViewModel implements Serializable {
    /**
     * buid
     */
    @ApiModelProperty("buid")
    private Long buId;
    @UdcName(udcName = "BU", codePropName = "buId")
    private String buName;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private String finPeriodName;
    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType1")
    private String jobType1Desc;
    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType2")
    private String jobType2Desc;
    /**
     * 合作方式
     */
    @ApiModelProperty("合作方式")
    private String coopType;
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "coopType")
    private String coopTypeDesc;
    /**
     * 城市级别
     */
    @ApiModelProperty("城市级别")
    private String cityLevel;
    @UdcName(udcName = "SYS:CITY_LEVEL", codePropName = "cityLevel")
    private String cityLevelDesc;
    /**
     * 单位当量收入
     */
    @ApiModelProperty("单位当量收入")
    private BigDecimal preeqvaAmt;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String lineStatus;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    @UdcName(udcName = "USER", codePropName = "resId")
    private String resName;


    /**
     * 起始时间
     */
    @ApiModelProperty("起始时间")
    private LocalDate startDate;

    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDate endDate;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer version;
    /**
     * 结算方式
     */
    @ApiModelProperty("结算方式 udc[org:employee:withdrawSettleMethod]")
    private String settleType;

    /**
     * 结算方式名称 udc[org:employee:withdrawSettleMethod]
     */
    @ApiModelProperty("结算方式名称 udc[org:employee:withdrawSettleMethod]")
    @UdcName(udcName = "org:employee:withdrawSettleMethod",codePropName = "settleType")
    private String settleTypeDesc;
}
