package com.elitesland.tw.tw5.api.prd.humanresources.query;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import com.elitesland.tw.tw5.api.common.TwQueryParam;



 /**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点
 */
 
@Data
@ApiModel(description = "绩效考核模板-绩效考核点")
public class PrdExamTempPointQuery extends TwQueryParam {


    /**
     * 模板id
     */
    @ApiModelProperty("模板id")
    private Long tempId;
    
    /**
     * 考核点来源
     */
    @ApiModelProperty("考核点来源")
    private String source;
    
    /**
     * 考核点名称
     */
    @ApiModelProperty("考核点名称")
    private String name;
    
    /**
     * 评分类型
     */
    @ApiModelProperty("评分类型")
    private String scoreType;
    
    /**
     * 权重比率
     */
    @ApiModelProperty("权重比率")
    private BigDecimal weightRatio;
    
    /**
     * 评分标准说明
     */
    @ApiModelProperty("评分标准说明")
    private String standardDesc;
    

}

