package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ResWithdrawApplyVO extends BaseViewModel {

    @ApiModelProperty("申请人id")
    private Long applyUserId;

    @ApiModelProperty("申请人")
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;

    @ApiModelProperty("提现单号")
    private String withdrawNo;

//    @ApiModelProperty("审批状态")
//    private String apprStatus;

    @ApiModelProperty("资源类型")
    private String resType;
    @UdcName(udcName = "org:employee:type", codePropName = "resType")
    private String resTypeName;

    @ApiModelProperty("提现当量")
    private BigDecimal withdrawEqva;

    @ApiModelProperty("提现金额")
    private BigDecimal withdrawAmt;

    @ApiModelProperty("调整提现金额")
    private BigDecimal adjWithdrawAmt;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("合作方式")
    private String cooperationMode;
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "cooperationMode")
    private String cooperationModeName;

    @ApiModelProperty("提现付款状态")
    private String withdrawPayStatus;
    @UdcName(udcName = "org:employee:withdrawPayStatus", codePropName = "withdrawPayStatus")
    private String withdrawPayStatusName;

    /**
     * 付款申请单Id
     */
    @ApiModelProperty("付款申请单Id")
    private Long paymentApplyId;

    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    private String paymentApplyNo;

    /**
     * 付款申请单类型
     */
    @ApiModelProperty("付款申请单类型")
    private String paymentApplicationType;

    /**
     * 采购协议编号
     */
    @ApiModelProperty("采购协议编号")
    private String docNo;


    private List<ResWithdrawApplyDetailVO> detailVOList;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }
}
