package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 用印申请
 *
 * @author wangly
 * @date 2023-09-14
 */
@Getter
@Setter
public class TBusiSignetApplyVO extends BaseViewModel implements Serializable {
    /**
     * BaseBU
     */
    @ApiModelProperty("BaseBU")
    private Long basebuId;

    @UdcName(udcName = "BU", codePropName = "basebuId")
    @ApiModelProperty("申请BU_Name")
    private String basebuIdDesc;

    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private Long ouId;

    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 印章场景
     */
    @ApiModelProperty("印章场景")
    private String signetScene;

    /**
     * 印章场景
     */
    @ApiModelProperty("印章场景")
    @UdcName(udcName = "COM:SIGNET_SCENE", codePropName = "signetScene")
    private String signetSceneDesc;

    /**
     * 是否需要打印
     */
    @ApiModelProperty("是否需要打印 1是0否")
    private Boolean printFlag;

    /**
     * 印章类型
     */
    @ApiModelProperty("印章类型")
    private String signetType;

    /**
     * 印章类型
     */
    @ApiModelProperty("印章类型")
    @UdcName(udcName = "COM:SIGNET_TYPE", codePropName = "signetType")
    private String signetTypeDesc;

    /**
     * 相关印章
     */
    @ApiModelProperty("相关印章")
    private String relatedSignet;

    /**
     * 相关印章
     */
    @ApiModelProperty("相关印章")
    @UdcName(udcName = "COM:RELATED_SIGNET", codePropName = "relatedSignet")
    private String relatedSignetDesc;

    /**
     * 印章所属公司
     */
    @ApiModelProperty("印章所属公司")
    private String signetBelongCompany;

    /**
     * 印章所属公司
     */
    @ApiModelProperty("印章所属公司")
    @UdcName(udcName = "COM:SIGNET_BELONG_COMPANY", codePropName = "signetBelongCompany")
    private String signetBelongCompanyDesc;

    /**
     * 印章用途
     */
    @ApiModelProperty("印章用途")
    private String signetPurpose;

    /**
     * 申请印章
     */
    @ApiModelProperty("申请印章")
    private String signetApply;

    /**
     * 是否外借
     */
    @ApiModelProperty("是否外借 1是0否")
    private Boolean lendFlag;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCode;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private Object fileData;
    /**
     * 印章归还说明
     */
    @ApiModelProperty("印章归还说明")
    private String signetReturnRemark;

    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applyResId;

    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @ApiModelProperty("申请人Name")
    private String applyUserName;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private String procInstStatus;

    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 预计归还时间
     */
    @ApiModelProperty("预计归还时间")
    private LocalDate predictReturnTime;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;

}
